<?php
/**
 * SubscriptionPaymentEntity
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payment Gateway APIs
 *
 * Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2023-08-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * SubscriptionPaymentEntity Class Doc Comment
 *
 * @category Class
 * @description The response returned in Get, Create or Manage Subscription Payment APIs.
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SubscriptionPaymentEntity implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SubscriptionPaymentEntity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'authorization_details' => '\Cashfree\Model\AuthorizationDetails',
        'cf_payment_id' => 'string',
        'cf_subscription_id' => 'string',
        'cf_txn_id' => 'string',
        'cf_order_id' => 'string',
        'failure_details' => '\Cashfree\Model\SubscriptionPaymentEntityFailureDetails',
        'payment_amount' => 'float',
        'payment_id' => 'string',
        'payment_initiated_date' => 'string',
        'payment_remarks' => 'string',
        'payment_schedule_date' => 'string',
        'payment_status' => 'string',
        'payment_type' => 'string',
        'retry_attempts' => 'int',
        'subscription_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'authorization_details' => null,
        'cf_payment_id' => null,
        'cf_subscription_id' => null,
        'cf_txn_id' => null,
        'cf_order_id' => null,
        'failure_details' => null,
        'payment_amount' => 'float64',
        'payment_id' => null,
        'payment_initiated_date' => null,
        'payment_remarks' => null,
        'payment_schedule_date' => null,
        'payment_status' => null,
        'payment_type' => null,
        'retry_attempts' => null,
        'subscription_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'authorization_details' => false,
		'cf_payment_id' => false,
		'cf_subscription_id' => false,
		'cf_txn_id' => false,
		'cf_order_id' => false,
		'failure_details' => false,
		'payment_amount' => false,
		'payment_id' => false,
		'payment_initiated_date' => false,
		'payment_remarks' => false,
		'payment_schedule_date' => false,
		'payment_status' => false,
		'payment_type' => false,
		'retry_attempts' => false,
		'subscription_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'authorization_details' => 'authorization_details',
        'cf_payment_id' => 'cf_payment_id',
        'cf_subscription_id' => 'cf_subscription_id',
        'cf_txn_id' => 'cf_txn_id',
        'cf_order_id' => 'cf_order_id',
        'failure_details' => 'failure_details',
        'payment_amount' => 'payment_amount',
        'payment_id' => 'payment_id',
        'payment_initiated_date' => 'payment_initiated_date',
        'payment_remarks' => 'payment_remarks',
        'payment_schedule_date' => 'payment_schedule_date',
        'payment_status' => 'payment_status',
        'payment_type' => 'payment_type',
        'retry_attempts' => 'retry_attempts',
        'subscription_id' => 'subscription_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'authorization_details' => 'setAuthorizationDetails',
        'cf_payment_id' => 'setCfPaymentId',
        'cf_subscription_id' => 'setCfSubscriptionId',
        'cf_txn_id' => 'setCfTxnId',
        'cf_order_id' => 'setCfOrderId',
        'failure_details' => 'setFailureDetails',
        'payment_amount' => 'setPaymentAmount',
        'payment_id' => 'setPaymentId',
        'payment_initiated_date' => 'setPaymentInitiatedDate',
        'payment_remarks' => 'setPaymentRemarks',
        'payment_schedule_date' => 'setPaymentScheduleDate',
        'payment_status' => 'setPaymentStatus',
        'payment_type' => 'setPaymentType',
        'retry_attempts' => 'setRetryAttempts',
        'subscription_id' => 'setSubscriptionId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'authorization_details' => 'getAuthorizationDetails',
        'cf_payment_id' => 'getCfPaymentId',
        'cf_subscription_id' => 'getCfSubscriptionId',
        'cf_txn_id' => 'getCfTxnId',
        'cf_order_id' => 'getCfOrderId',
        'failure_details' => 'getFailureDetails',
        'payment_amount' => 'getPaymentAmount',
        'payment_id' => 'getPaymentId',
        'payment_initiated_date' => 'getPaymentInitiatedDate',
        'payment_remarks' => 'getPaymentRemarks',
        'payment_schedule_date' => 'getPaymentScheduleDate',
        'payment_status' => 'getPaymentStatus',
        'payment_type' => 'getPaymentType',
        'retry_attempts' => 'getRetryAttempts',
        'subscription_id' => 'getSubscriptionId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('authorization_details', $data ?? [], null);
        $this->setIfExists('cf_payment_id', $data ?? [], null);
        $this->setIfExists('cf_subscription_id', $data ?? [], null);
        $this->setIfExists('cf_txn_id', $data ?? [], null);
        $this->setIfExists('cf_order_id', $data ?? [], null);
        $this->setIfExists('failure_details', $data ?? [], null);
        $this->setIfExists('payment_amount', $data ?? [], null);
        $this->setIfExists('payment_id', $data ?? [], null);
        $this->setIfExists('payment_initiated_date', $data ?? [], null);
        $this->setIfExists('payment_remarks', $data ?? [], null);
        $this->setIfExists('payment_schedule_date', $data ?? [], null);
        $this->setIfExists('payment_status', $data ?? [], null);
        $this->setIfExists('payment_type', $data ?? [], null);
        $this->setIfExists('retry_attempts', $data ?? [], null);
        $this->setIfExists('subscription_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets authorization_details
     *
     * @return \Cashfree\Model\AuthorizationDetails|null
     */
    public function getAuthorizationDetails()
    {
        return $this->container['authorization_details'];
    }

    /**
     * Sets authorization_details
     *
     * @param \Cashfree\Model\AuthorizationDetails|null $authorization_details authorization_details
     *
     * @return self
     */
    public function setAuthorizationDetails($authorization_details)
    {
        if (is_null($authorization_details)) {
            throw new \InvalidArgumentException('non-nullable authorization_details cannot be null');
        }
        $this->container['authorization_details'] = $authorization_details;

        return $this;
    }

    /**
     * Gets cf_payment_id
     *
     * @return string|null
     */
    public function getCfPaymentId()
    {
        return $this->container['cf_payment_id'];
    }

    /**
     * Sets cf_payment_id
     *
     * @param string|null $cf_payment_id Cashfree subscription payment reference number
     *
     * @return self
     */
    public function setCfPaymentId($cf_payment_id)
    {
        if (is_null($cf_payment_id)) {
            throw new \InvalidArgumentException('non-nullable cf_payment_id cannot be null');
        }
        $this->container['cf_payment_id'] = $cf_payment_id;

        return $this;
    }

    /**
     * Gets cf_subscription_id
     *
     * @return string|null
     */
    public function getCfSubscriptionId()
    {
        return $this->container['cf_subscription_id'];
    }

    /**
     * Sets cf_subscription_id
     *
     * @param string|null $cf_subscription_id Cashfree subscription reference number
     *
     * @return self
     */
    public function setCfSubscriptionId($cf_subscription_id)
    {
        if (is_null($cf_subscription_id)) {
            throw new \InvalidArgumentException('non-nullable cf_subscription_id cannot be null');
        }
        $this->container['cf_subscription_id'] = $cf_subscription_id;

        return $this;
    }

    /**
     * Gets cf_txn_id
     *
     * @return string|null
     */
    public function getCfTxnId()
    {
        return $this->container['cf_txn_id'];
    }

    /**
     * Sets cf_txn_id
     *
     * @param string|null $cf_txn_id Cashfree subscription payment transaction ID
     *
     * @return self
     */
    public function setCfTxnId($cf_txn_id)
    {
        if (is_null($cf_txn_id)) {
            throw new \InvalidArgumentException('non-nullable cf_txn_id cannot be null');
        }
        $this->container['cf_txn_id'] = $cf_txn_id;

        return $this;
    }

    /**
     * Gets cf_order_id
     *
     * @return string|null
     */
    public function getCfOrderId()
    {
        return $this->container['cf_order_id'];
    }

    /**
     * Sets cf_order_id
     *
     * @param string|null $cf_order_id Cashfree subscription payment order ID
     *
     * @return self
     */
    public function setCfOrderId($cf_order_id)
    {
        if (is_null($cf_order_id)) {
            throw new \InvalidArgumentException('non-nullable cf_order_id cannot be null');
        }
        $this->container['cf_order_id'] = $cf_order_id;

        return $this;
    }

    /**
     * Gets failure_details
     *
     * @return \Cashfree\Model\SubscriptionPaymentEntityFailureDetails|null
     */
    public function getFailureDetails()
    {
        return $this->container['failure_details'];
    }

    /**
     * Sets failure_details
     *
     * @param \Cashfree\Model\SubscriptionPaymentEntityFailureDetails|null $failure_details failure_details
     *
     * @return self
     */
    public function setFailureDetails($failure_details)
    {
        if (is_null($failure_details)) {
            throw new \InvalidArgumentException('non-nullable failure_details cannot be null');
        }
        $this->container['failure_details'] = $failure_details;

        return $this;
    }

    /**
     * Gets payment_amount
     *
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->container['payment_amount'];
    }

    /**
     * Sets payment_amount
     *
     * @param float|null $payment_amount The charge amount of the payment.
     *
     * @return self
     */
    public function setPaymentAmount($payment_amount)
    {
        if (is_null($payment_amount)) {
            throw new \InvalidArgumentException('non-nullable payment_amount cannot be null');
        }
        $this->container['payment_amount'] = $payment_amount;

        return $this;
    }

    /**
     * Gets payment_id
     *
     * @return string|null
     */
    public function getPaymentId()
    {
        return $this->container['payment_id'];
    }

    /**
     * Sets payment_id
     *
     * @param string|null $payment_id A unique ID passed by merchant for identifying the transaction.
     *
     * @return self
     */
    public function setPaymentId($payment_id)
    {
        if (is_null($payment_id)) {
            throw new \InvalidArgumentException('non-nullable payment_id cannot be null');
        }
        $this->container['payment_id'] = $payment_id;

        return $this;
    }

    /**
     * Gets payment_initiated_date
     *
     * @return string|null
     */
    public function getPaymentInitiatedDate()
    {
        return $this->container['payment_initiated_date'];
    }

    /**
     * Sets payment_initiated_date
     *
     * @param string|null $payment_initiated_date The date on which the payment was initiated.
     *
     * @return self
     */
    public function setPaymentInitiatedDate($payment_initiated_date)
    {
        if (is_null($payment_initiated_date)) {
            throw new \InvalidArgumentException('non-nullable payment_initiated_date cannot be null');
        }
        $this->container['payment_initiated_date'] = $payment_initiated_date;

        return $this;
    }

    /**
     * Gets payment_remarks
     *
     * @return string|null
     */
    public function getPaymentRemarks()
    {
        return $this->container['payment_remarks'];
    }

    /**
     * Sets payment_remarks
     *
     * @param string|null $payment_remarks Payment remarks.
     *
     * @return self
     */
    public function setPaymentRemarks($payment_remarks)
    {
        if (is_null($payment_remarks)) {
            throw new \InvalidArgumentException('non-nullable payment_remarks cannot be null');
        }
        $this->container['payment_remarks'] = $payment_remarks;

        return $this;
    }

    /**
     * Gets payment_schedule_date
     *
     * @return string|null
     */
    public function getPaymentScheduleDate()
    {
        return $this->container['payment_schedule_date'];
    }

    /**
     * Sets payment_schedule_date
     *
     * @param string|null $payment_schedule_date The date on which the payment is scheduled to be processed.
     *
     * @return self
     */
    public function setPaymentScheduleDate($payment_schedule_date)
    {
        if (is_null($payment_schedule_date)) {
            throw new \InvalidArgumentException('non-nullable payment_schedule_date cannot be null');
        }
        $this->container['payment_schedule_date'] = $payment_schedule_date;

        return $this;
    }

    /**
     * Gets payment_status
     *
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->container['payment_status'];
    }

    /**
     * Sets payment_status
     *
     * @param string|null $payment_status Status of the payment.
     *
     * @return self
     */
    public function setPaymentStatus($payment_status)
    {
        if (is_null($payment_status)) {
            throw new \InvalidArgumentException('non-nullable payment_status cannot be null');
        }
        $this->container['payment_status'] = $payment_status;

        return $this;
    }

    /**
     * Gets payment_type
     *
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->container['payment_type'];
    }

    /**
     * Sets payment_type
     *
     * @param string|null $payment_type Payment type. Can be AUTH or CHARGE.
     *
     * @return self
     */
    public function setPaymentType($payment_type)
    {
        if (is_null($payment_type)) {
            throw new \InvalidArgumentException('non-nullable payment_type cannot be null');
        }
        $this->container['payment_type'] = $payment_type;

        return $this;
    }

    /**
     * Gets retry_attempts
     *
     * @return int|null
     */
    public function getRetryAttempts()
    {
        return $this->container['retry_attempts'];
    }

    /**
     * Sets retry_attempts
     *
     * @param int|null $retry_attempts Retry attempts.
     *
     * @return self
     */
    public function setRetryAttempts($retry_attempts)
    {
        if (is_null($retry_attempts)) {
            throw new \InvalidArgumentException('non-nullable retry_attempts cannot be null');
        }
        $this->container['retry_attempts'] = $retry_attempts;

        return $this;
    }

    /**
     * Gets subscription_id
     *
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return $this->container['subscription_id'];
    }

    /**
     * Sets subscription_id
     *
     * @param string|null $subscription_id A unique ID passed by merchant for identifying the subscription.
     *
     * @return self
     */
    public function setSubscriptionId($subscription_id)
    {
        if (is_null($subscription_id)) {
            throw new \InvalidArgumentException('non-nullable subscription_id cannot be null');
        }
        $this->container['subscription_id'] = $subscription_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


